# StyleSeat Local Build - Setup Instructions

## Current Status

The StyleSeat application has been created with all necessary files. Now we need to complete the dependency installation and local setup.

### What Has Been Done ✅
- ✅ All application files created (100+ files)
- ✅ Database migrations designed  
- ✅ Models, Controllers, and Services written
- ✅ Routes configured
- ✅ Views (Blade templates) created
- ✅ Configuration files set up
- ✅ `.env` file created with example values
- ✅ `setup.bat` script created for automated setup

### What's In Progress ⏳
- ⏳ Composer (PHP dependencies) - installing Laravel, Stripe Cashier, Firebase SDK
- ⏳ NPM (JavaScript dependencies) - installing Tailwind CSS, Vite, Alpine.js

---

## Manual Setup Instructions

If the automated process takes too long or encounters issues, follow these manual steps:

### Prerequisites
- **PHP 8.3** (installed at `C:\php`)
- **MySQL 5.7+** (needs to be installed and running)
- **Node.js 18+** (npm 10.9.3 confirmed present)
- **Composer** (PHAR at `C:\php\composer.phar`)

### Step 1: Install PHP Composer Dependencies

```powershell
cd c:\Users\USER\OneDrive\Documents\styleseatApp

# Install dependencies with platform requirement ignores
php C:\php\composer.phar install `
  --ignore-platform-req=ext-fileinfo `
  --ignore-platform-req=ext-sodium `
  --no-interaction `
  --prefer-dist
```

**Expected output**: 
- Dependencies will be downloaded (~150MB)
- `vendor/` directory created with all packages
- `composer.lock` file generated

**Time**: 5-15 minutes depending on internet speed

### Step 2: Create Database

Using MySQL command line or MySQL Workbench:

```sql
CREATE DATABASE IF NOT EXISTS styleseat;
```

Or via command line:
```bash
mysql -u root -p -e "CREATE DATABASE IF NOT EXISTS styleseat;"
```

Update `.env` file with your database credentials if different:
```
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=styleseat
DB_USERNAME=root
DB_PASSWORD=  # your password
```

### Step 3: Install JavaScript Dependencies

```powershell
cd c:\Users\USER\OneDrive\Documents\styleseatApp
npm install
```

**Expected output**: 
- Installs Tailwind CSS, Vite, Alpine.js, and other JS packages
- `node_modules/` directory created
- `package-lock.json` file generated

**Time**: 2-5 minutes

### Step 4: Generate Laravel Key

```powershell
php artisan key:generate
```

This creates the `APP_KEY` in `.env` (already done, but good to refresh)

### Step 5: Run Database Migrations

```powershell
php artisan migrate
```

This creates all database tables:
- users
- professional_profiles
- services
- bookings
- reviews
- transactions
- availability
- blocked_times
- gallery
- favorites
- settings
- analytics_cache

### Step 6: Seed Database with Mock Data

```powershell
php artisan db:seed
```

This generates:
- 1 admin user
- 75 client users
- 25 professional users
- 250+ bookings
- 1000+ transactions
- 150+ reviews
- And more test data

### Step 7: Build Frontend Assets

```powershell
npm run build
```

Or for development with watch mode:
```powershell
npm run dev
```

This compiles:
- Tailwind CSS → `public/css/app.css`
- JavaScript/Alpine → `public/js/app.js`
- Vite bundles for production

### Step 8: Start Development Server

```powershell
php artisan serve
```

The application will be available at:
- **URL**: http://localhost:8000
- **Admin Email**: admin@styleseat.local
- **Default Password**: password

---

## Quick Start After Setup

Once everything is installed:

**Terminal 1** - Start Laravel server:
```powershell
php artisan serve
```

**Terminal 2** - Watch assets (optional, for development):
```powershell
npm run dev
```

Then visit `http://localhost:8000`

---

## Database Credentials

The seeded application includes demo accounts:

### Admin Account
- **Email**: admin@styleseat.local  
- **Password**: password
- **Role**: Admin
- **Access**: /admin/dashboard

### Sample Client Account
- **Email**: client1@styleseat.local
- **Password**: password
- **Role**: Client
- **Access**: /client/dashboard

### Sample Professional Account
- **Email**: professional1@styleseat.local
- **Password**: password
- **Role**: Professional  
- **Access**: /professional/dashboard

---

## Troubleshooting

### Issue: "PHP is not recognized"
**Solution**: Add PHP to PATH or use full path `C:\php\php.exe`

### Issue: "Composer not found"
**Solution**: Use full path `C:\php\composer.phar`

### Issue: "MySQL connection error"
**Solution**: 
- Ensure MySQL is running
- Check DB_HOST, DB_USERNAME, DB_PASSWORD in `.env`
- Verify database exists: `CREATE DATABASE styleseat;`

### Issue: "npm ERR! ENOENT: no such file or directory"
**Solution**: 
- Delete `node_modules` and `package-lock.json`
- Run `npm install` again
- Ensure npm is in PATH: `npm --version`

### Issue: "Vite compilation error"
**Solution**: 
- Delete `node_modules` folder
- Run `npm install`
- Try `npm run build`

### Issue: "SQLSTATE[HY000] [1045]"
**Solution**: Database authentication failed
- Check MySQL is running
- Verify username/password in `.env`
- Ensure database exists

---

## Next Steps After Local Setup

1. **Configure Firebase** (for authentication)
   - Get credentials from Firebase Console
   - Save as `firebase-credentials.json` in project root
   - Update `.env` with Firebase configuration

2. **Configure Stripe** (for payments)
   - Get test API keys from Stripe Dashboard
   - Update `STRIPE_PUBLIC_KEY` and `STRIPE_SECRET_KEY` in `.env`

3. **Configure Email** (for notifications)
   - Update `MAIL_MAILER`, `MAIL_HOST`, etc. in `.env`
   - Or use `log` driver for development (already set)

4. **Start Developing**
   - Customize views in `resources/views/`
   - Modify controllers in `app/Http/Controllers/`
   - Update models in `app/Models/`
   - Add new features as needed

---

## File Structure Reference

```
styleseatApp/
├── app/                      # Application code
│   ├── Http/
│   │   ├── Controllers/     # Request handlers
│   │   ├── Middleware/      # Request middleware
│   │   └── Requests/        # Form validation
│   ├── Models/              # Database models
│   ├── Services/            # Business logic
│   └── Policies/            # Authorization
├── database/
│   ├── migrations/          # Database schemas
│   ├── seeders/             # Test data generators
│   └── factories/           # Model factories
├── resources/
│   ├── views/               # Blade templates
│   ├── css/                 # Stylesheets
│   └── js/                  # JavaScript
├── routes/
│   └── web.php              # Web routes
├── config/                  # Configuration files
├── public/                  # Web server document root
│   ├── index.php            # Entry point
│   ├── manifest.json        # PWA config
│   └── service-worker.js    # Offline support
├── .env                     # Environment variables
├── composer.json            # PHP dependencies
├── package.json             # JavaScript dependencies
└── artisan                  # Laravel CLI tool
```

---

## Important URLs

| Route | URL | Purpose |
|-------|-----|---------|
| Home | http://localhost:8000 | Landing page |
| Search | http://localhost:8000/search | Find professionals |
| Client Dashboard | http://localhost:8000/client/dashboard | Client area |
| Professional Dashboard | http://localhost:8000/professional/dashboard | Professional area |
| Admin Dashboard | http://localhost:8000/admin/dashboard | Admin panel |
| About | http://localhost:8000/about | About page |
| Contact | http://localhost:8000/contact | Contact page |

---

## Terminal Commands Summary

```powershell
# Install dependencies
php C:\php\composer.phar install --ignore-platform-req=ext-fileinfo --ignore-platform-req=ext-sodium
npm install

# Create database
mysql -u root -p -e "CREATE DATABASE styleseat;"

# Run migrations and seeders
php artisan migrate
php artisan db:seed

# Build assets
npm run build        # Production build
npm run dev         # Development with watch

# Start servers
php artisan serve   # Laravel (Terminal 1)
npm run dev         # Vite (Terminal 2, optional)

# Useful artisan commands
php artisan tinker           # Interactive shell
php artisan make:model Name  # Create model
php artisan make:controller NameController  # Create controller
php artisan make:migration create_table_name  # Create migration
```

---

## Support & Documentation

Full documentation available in:
- **README.md** - Complete project overview
- **INSTALLATION_GUIDE.md** - Detailed installation steps  
- **FILE_INDEX.md** - Complete file listing
- **PROJECT_SUMMARY.md** - Feature summary
- **COMPLETION_SUMMARY.md** - What was built

---

**StyleSeat v1.0** - Ready for Development

*Last Updated: December 7, 2025*
