# StyleSeat - Quick Start After Installation

## 🚀 Start Here After Dependencies Install

Once `npm install` and `composer install` are complete, follow these steps to get the app running locally.

### Step 1: Start a New Terminal and Navigate

```powershell
cd c:\Users\USER\OneDrive\Documents\styleseatApp
```

### Step 2: Create Database

**Option A: Using Command Line**
```powershell
mysql -u root -p
# When prompted for password, enter your MySQL password (leave blank for no password)
```

Then in MySQL:
```sql
CREATE DATABASE styleseat;
EXIT;
```

**Option B: Using MySQL Workbench or phpMyAdmin**
- Create a new database named `styleseat`
- Ensure character set is `utf8mb4`

### Step 3: Run Migrations

```powershell
php artisan migrate
```

Expected output:
```
Migration table created successfully.
Migrating: 2024_12_01_000000_create_users_table
Migrated:  2024_12_01_000000_create_users_table
Migrating: 2024_12_01_000001_create_professional_profiles_table
...
```

This creates all 12 database tables.

### Step 4: Seed Test Data (Optional but Recommended)

```powershell
php artisan db:seed
```

Expected output:
```
Database seeded successfully.
```

This creates:
- 1 admin user
- 75 client users
- 25 professional users
- 250+ bookings
- 1000+ transactions
- 150+ reviews
- And more test data

### Step 5: Build Frontend Assets

```powershell
npm run build
```

Or for development with auto-recompile:
```powershell
npm run dev
```

### Step 6: Start the Server

Open a new PowerShell terminal and run:

```powershell
cd c:\Users\USER\OneDrive\Documents\styleseatApp
php artisan serve
```

Expected output:
```
INFO  Server running on [http://127.0.0.1:8000].

Press Ctrl+C to quit
```

### Step 7: Access the Application

Open your browser and go to:
```
http://localhost:8000
```

---

## 📱 Login Credentials

After seeding, you can log in with these accounts:

### Admin Account
- **Email**: admin@styleseat.local
- **Password**: password
- **Role**: Admin
- **Access**: `/admin/dashboard`

### Client Account  
- **Email**: client1@styleseat.local
- **Password**: password
- **Role**: Client
- **Access**: `/client/dashboard`

### Professional Account
- **Email**: professional1@styleseat.local
- **Password**: password
- **Role**: Professional
- **Access**: `/professional/dashboard`

---

## 🔧 Terminal Setup (Recommended)

For best development experience, open 2 PowerShell terminals:

### Terminal 1: Laravel Server
```powershell
cd c:\Users\USER\OneDrive\Documents\styleseatApp
php artisan serve
```
→ Application available at `http://localhost:8000`

### Terminal 2: Asset Watch (Optional)
```powershell
cd c:\Users\USER\OneDrive\Documents\styleseatApp
npm run dev
```
→ Vite will watch CSS/JS files and auto-recompile

---

## 📍 Main URLs

| Page | URL |
|------|-----|
| **Home** | http://localhost:8000 |
| **Search** | http://localhost:8000/search |
| **Professional Profile** | http://localhost:8000/professional/1 |
| **Client Dashboard** | http://localhost:8000/client/dashboard |
| **Professional Dashboard** | http://localhost:8000/professional/dashboard |
| **Admin Dashboard** | http://localhost:8000/admin/dashboard |
| **About** | http://localhost:8000/about |
| **Contact** | http://localhost:8000/contact |

---

## 🛠️ Useful Artisan Commands

```powershell
# Database
php artisan migrate                   # Run migrations
php artisan migrate:rollback         # Rollback migrations
php artisan db:seed                  # Run seeders
php artisan migrate:fresh --seed     # Reset and reseed

# Code
php artisan tinker                   # Interactive PHP shell
php artisan make:model Name          # Create model
php artisan make:controller NameController  # Create controller
php artisan make:migration table_name # Create migration

# Routes & Cache
php artisan route:list               # Show all routes
php artisan optimize                 # Cache routes/config
php artisan optimize:clear           # Clear cache

# Other
php artisan key:generate             # Generate APP_KEY
php artisan storage:link             # Link storage directory
```

---

## 🐛 Troubleshooting Common Issues

### Database Connection Error
```
SQLSTATE[HY000] [1045] Access denied for user 'root'@'localhost'
```

**Solution**: 
- Check `.env` DB_HOST, DB_USERNAME, DB_PASSWORD
- Ensure MySQL is running
- Verify database exists: `mysql -u root -p -e "SHOW DATABASES;"`

### Port 8000 Already in Use
```
Address already in use
```

**Solution**:
```powershell
php artisan serve --port=8001
```

### Node Modules Issues
```
npm ERR! MODULE_NOT_FOUND
```

**Solution**:
```powershell
Remove-Item -Recurse -Force node_modules
Remove-Item package-lock.json
npm install
```

### Permission Denied Errors
```
Permission denied in C:\...\storage
```

**Solution**:
```powershell
# Windows typically doesn't have permission issues, but if you do:
icacls "c:\Users\USER\OneDrive\Documents\styleseatApp\storage" /grant Everyone:F
```

---

## 📖 Documentation

- **README.md** - Complete project overview
- **INSTALLATION_GUIDE.md** - Detailed setup steps
- **LOCAL_SETUP.md** - Manual configuration guide
- **FILE_INDEX.md** - Complete file structure
- **PROJECT_SUMMARY.md** - Feature summary
- **COMPLETION_SUMMARY.md** - What was built

---

## 🎯 Next Steps for Development

### Configure External Services

**Firebase Authentication**:
1. Create project at https://console.firebase.google.com
2. Download service account JSON
3. Save as `firebase-credentials.json` in project root
4. Update `.env` with Firebase credentials

**Stripe Payments**:
1. Create account at https://dashboard.stripe.com
2. Get test API keys
3. Add to `.env`:
   ```
   STRIPE_PUBLIC_KEY=pk_test_xxx
   STRIPE_SECRET_KEY=sk_test_xxx
   ```

**Email Service**:
1. Update `.env` MAIL_* variables
2. Or use `log` driver for development (already set)

### Customize Application

1. **Modify Views**: Edit files in `resources/views/`
2. **Update Models**: Modify files in `app/Models/`
3. **Change Controllers**: Edit files in `app/Http/Controllers/`
4. **Add Features**: Create new controllers, models, migrations as needed

### Run Tests

```powershell
# Run all tests
php artisan test

# Run specific test
php artisan test tests/Feature/BookingTest.php

# Run with coverage
php artisan test --coverage
```

---

## 📊 Project Structure

```
styleseatApp/
├── app/
│   ├── Http/
│   │   ├── Controllers/     ← Request handlers
│   │   ├── Middleware/      ← Request middleware
│   │   └── Requests/        ← Form validation
│   ├── Models/              ← Database models (11 models)
│   ├── Services/            ← Business logic (3 services)
│   └── Policies/            ← Authorization
├── database/
│   ├── migrations/          ← Database schemas (12 tables)
│   ├── seeders/             ← Test data generators
│   └── factories/           ← Model factories
├── resources/
│   ├── views/               ← Blade templates (25+ files)
│   ├── css/app.css          ← Tailwind CSS
│   └── js/app.js            ← Alpine.js & setup
├── routes/
│   └── web.php              ← All routes (140+ routes)
├── config/                  ← Configuration files
├── public/
│   ├── index.php            ← Entry point
│   ├── manifest.json        ← PWA config
│   └── service-worker.js    ← Offline support
├── storage/                 ← Temporary files
├── vendor/                  ← PHP packages (created by composer)
├── node_modules/            ← JavaScript packages (created by npm)
├── .env                     ← Environment variables
├── artisan                  ← Laravel CLI
├── composer.json            ← PHP dependencies
└── package.json             ← JavaScript dependencies
```

---

## 💻 System Requirements

✅ **PHP**: 8.2+ (installed: 8.3.27)
✅ **MySQL**: 5.7+ 
✅ **Node.js**: 14+ (npm 10.9.3)
✅ **Composer**: Latest

---

## 🎉 You're Ready!

Everything is configured and ready to go. Just follow the 7 steps at the top of this guide and you'll have the StyleSeat application running on your local machine.

**Happy Coding!**

---

*Last Updated: December 7, 2025*
*StyleSeat v1.0 - Production Ready*
