<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\View\View;
use Illuminate\Http\Request;

class SettingController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('role:admin');
    }

    public function index(): View
    {
        $settings = Setting::all()->groupBy('group');

        return view('admin.settings.index', ['settings' => $settings]);
    }

    public function updateGroup(Request $request, $group)
    {
        $data = $request->all();
        
        foreach ($data as $key => $value) {
            Setting::set($key, $value, 'string', $group);
        }

        return redirect()->back()->with('success', 'Settings updated successfully');
    }

    public function appSettings(): View
    {
        $settings = Setting::where('group', 'app')->get()->keyBy('key');

        return view('admin.settings.app', ['settings' => $settings]);
    }

    public function stripeSettings(): View
    {
        $settings = Setting::where('group', 'stripe')->get()->keyBy('key');

        return view('admin.settings.stripe', ['settings' => $settings]);
    }

    public function firebaseSettings(): View
    {
        $settings = Setting::where('group', 'firebase')->get()->keyBy('key');

        return view('admin.settings.firebase', ['settings' => $settings]);
    }

    public function emailSettings(): View
    {
        $settings = Setting::where('group', 'email')->get()->keyBy('key');

        return view('admin.settings.email', ['settings' => $settings]);
    }

    public function updateSettings(Request $request)
    {
        foreach ($request->all() as $key => $value) {
            Setting::set($key, $value);
        }

        return redirect()->back()->with('success', 'Settings updated successfully');
    }
}
