<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\ProfessionalProfile;
use Illuminate\View\View;

class HomeController extends Controller
{
    public function index(): View
    {
        $featuredProfessionals = ProfessionalProfile::where('is_published', true)
            ->orderByRaw('RAND()')
            ->limit(6)
            ->with('user', 'reviews')
            ->get();

        $popularCities = [
            'Dallas', 'Chicago', 'Atlanta', 'New York', 
            'Los Angeles', 'Houston', 'Phoenix'
        ];

        $serviceCategories = [
            'Braids', 'Locs', 'Natural Hair', 'Haircut',
            'Nails', 'Makeup', 'Kids', 'Color'
        ];

        return view('home', [
            'featuredProfessionals' => $featuredProfessionals,
            'popularCities' => $popularCities,
            'serviceCategories' => $serviceCategories,
        ]);
    }

    public function about(): View
    {
        return view('about');
    }

    public function contact(): View
    {
        return view('contact');
    }
}
