<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Kreait\Firebase\Factory;
use Kreait\Firebase\Exception\Auth\InvalidIdToken;

class VerifyFirebaseToken
{
    public function handle(Request $request, Closure $next)
    {
        $token = $request->bearerToken();

        if (!$token) {
            return response()->json(['error' => 'Unauthorized'], 401);
        }

        try {
            $factory = (new Factory)
                ->withServiceAccount(config('firebase.credentials_path'));
            
            $auth = $factory->createAuth();
            $verifiedIdToken = $auth->verifyIdToken($token);
            $uid = $verifiedIdToken->claims()->get('sub');

            // Find or create user from Firebase UID
            $user = \App\Models\User::firstOrCreate(
                ['firebase_uid' => $uid],
                [
                    'email' => $verifiedIdToken->claims()->get('email'),
                    'name' => $verifiedIdToken->claims()->get('name') ?? 'User',
                    'role' => 'client',
                ]
            );

            $request->setUserResolver(fn () => $user);

        } catch (InvalidIdToken $e) {
            return response()->json(['error' => 'Invalid token'], 401);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Authentication failed'], 401);
        }

        return $next($request);
    }
}
