<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BlockedTime extends Model
{
    use HasFactory;

    protected $fillable = [
        'professional_id', 'date', 'start_time', 'end_time', 'reason',
    ];

    protected $casts = [
        'date' => 'date',
    ];

    public function professional()
    {
        return $this->belongsTo(ProfessionalProfile::class);
    }
}
