<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    use HasFactory;

    protected $fillable = [
        'professional_id', 'name', 'description', 'category',
        'duration', 'price', 'status', 'bookings_count',
    ];

    public function professional()
    {
        return $this->belongsTo(ProfessionalProfile::class);
    }

    public function bookings()
    {
        return $this->hasMany(Booking::class);
    }

    public function isActive()
    {
        return $this->status === 'active';
    }
}
