<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    use HasFactory;

    protected $fillable = [
        'key', 'value', 'type', 'group', 'description', 'is_secret',
    ];

    protected $casts = [
        'is_secret' => 'boolean',
    ];

    public static function get($key, $default = null)
    {
        $setting = self::where('key', $key)->first();
        
        if (!$setting) {
            return $default;
        }

        return match ($setting->type) {
            'json' => json_decode($setting->value, true),
            'boolean' => (bool) $setting->value,
            'integer' => (int) $setting->value,
            default => $setting->value,
        };
    }

    public static function set($key, $value, $type = 'string', $group = null)
    {
        $setting = self::firstOrNew(['key' => $key]);
        
        $setting->value = match ($type) {
            'json' => json_encode($value),
            default => $value,
        };
        
        $setting->type = $type;
        $setting->group = $group ?? $setting->group;
        
        $setting->save();
        
        return $setting;
    }
}
