<?php

namespace App\Services;

use Kreait\Firebase\Factory;
use Kreait\Firebase\Auth;

class FirebaseService
{
    protected $auth;

    public function __construct()
    {
        $factory = (new Factory)
            ->withServiceAccount(config('firebase.credentials_path'));
        
        $this->auth = $factory->createAuth();
    }

    public function getAuth(): Auth
    {
        return $this->auth;
    }

    public function verifyIdToken($token)
    {
        try {
            return $this->auth->verifyIdToken($token);
        } catch (\Exception $e) {
            return null;
        }
    }

    public function getUserByEmail($email)
    {
        try {
            return $this->auth->getUserByEmail($email);
        } catch (\Exception $e) {
            return null;
        }
    }

    public function createUser($email, $password, $displayName = null)
    {
        try {
            return $this->auth->createUserWithEmailAndPassword($email, $password);
        } catch (\Exception $e) {
            return null;
        }
    }

    public function deleteUser($uid)
    {
        try {
            $this->auth->deleteUser($uid);
            return true;
        } catch (\Exception $e) {
            return false;
        }
    }
}
