<?php

namespace Database\Factories;

use App\Models\Booking;
use Illuminate\Database\Eloquent\Factories\Factory;

class BookingFactory extends Factory
{
    protected $model = Booking::class;

    public function definition(): array
    {
        return [
            'scheduled_at' => $this->faker->dateTimeBetween('-30 days', '+30 days'),
            'duration' => $this->faker->randomElement([30, 45, 60, 90, 120]),
            'city' => $this->faker->randomElement(['Dallas', 'Chicago', 'Atlanta', 'New York', 'Los Angeles', 'Houston', 'Phoenix']),
            'amount' => $this->faker->randomFloat(2, 25, 250),
            'status' => $this->faker->randomElement(['pending', 'confirmed', 'completed', 'cancelled']),
            'notes' => $this->faker->sentence(),
        ];
    }

    public function pending(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'pending',
        ]);
    }

    public function confirmed(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'confirmed',
        ]);
    }

    public function completed(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'completed',
            'completed_at' => now(),
        ]);
    }
}
