<?php

namespace Database\Factories;

use App\Models\Service;
use Illuminate\Database\Eloquent\Factories\Factory;

class ServiceFactory extends Factory
{
    protected $model = Service::class;

    public function definition(): array
    {
        $categories = ['Braids', 'Locs', 'Natural Hair', 'Haircut', 'Nails', 'Makeup', 'Kids', 'Color'];
        $category = $this->faker->randomElement($categories);
        
        $serviceName = match ($category) {
            'Haircut' => $this->faker->randomElement(['Regular Haircut', 'Fade', 'Buzz Cut', 'Layered Cut']),
            'Braids' => $this->faker->randomElement(['Box Braids', 'Cornrows', 'Goddess Braids', 'Feed-in Braids']),
            'Nails' => $this->faker->randomElement(['Manicure', 'Pedicure', 'Gel Polish', 'Acrylics']),
            'Makeup' => $this->faker->randomElement(['Full Face', 'Bridal', 'Party', 'Natural']),
            'Color' => $this->faker->randomElement(['Full Color', 'Highlights', 'Balayage', 'Ombre']),
            default => $this->faker->word(),
        };

        return [
            'name' => $serviceName,
            'description' => $this->faker->text(100),
            'category' => $category,
            'duration' => $this->faker->randomElement([30, 45, 60, 90, 120]),
            'price' => $this->faker->randomFloat(2, 25, 250),
            'status' => 'active',
            'bookings_count' => $this->faker->numberBetween(0, 50),
        ];
    }
}
