<?php

namespace Database\Factories;

use App\Models\Transaction;
use Illuminate\Database\Eloquent\Factories\Factory;

class TransactionFactory extends Factory
{
    protected $model = Transaction::class;

    public function definition(): array
    {
        $amount = $this->faker->randomFloat(2, 25, 250);
        $platformFee = $amount * 0.2; // 20% commission
        $profitAmount = $amount - $platformFee;

        return [
            'stripe_payment_id' => 'ch_' . $this->faker->numerify('##################'),
            'stripe_payment_intent' => 'pi_' . $this->faker->numerify('##################'),
            'amount' => $amount,
            'platform_fee' => $platformFee,
            'professional_payout' => $profitAmount,
            'currency' => 'USD',
            'status' => $this->faker->randomElement(['pending', 'succeeded', 'failed']),
        ];
    }

    public function succeeded(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'succeeded',
        ]);
    }

    public function failed(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'failed',
        ]);
    }
}
