<?php

namespace Database\Factories;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class UserFactory extends Factory
{
    protected $model = User::class;

    public function definition(): array
    {
        return [
            'firebase_uid' => Str::random(28),
            'name' => $this->faker->name(),
            'email' => $this->faker->unique()->safeEmail(),
            'phone' => $this->faker->phoneNumber(),
            'avatar' => 'https://i.pravatar.cc/150?img=' . random_int(1, 70),
            'role' => $this->faker->randomElement(['client', 'professional']),
            'city' => $this->faker->randomElement(['Dallas', 'Chicago', 'Atlanta', 'New York', 'Los Angeles', 'Houston', 'Phoenix']),
            'status' => 'active',
            'email_verified_at' => now(),
            'remember_token' => Str::random(10),
        ];
    }

    public function client(): static
    {
        return $this->state(fn (array $attributes) => [
            'role' => 'client',
        ]);
    }

    public function professional(): static
    {
        return $this->state(fn (array $attributes) => [
            'role' => 'professional',
        ]);
    }

    public function admin(): static
    {
        return $this->state(fn (array $attributes) => [
            'role' => 'admin',
            'email' => 'admin@styleseat.local',
        ]);
    }
}
