<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('firebase_uid')->unique()->nullable();
            $table->string('name');
            $table->string('email')->unique();
            $table->string('phone')->nullable();
            $table->string('avatar')->nullable();
            $table->enum('role', ['client', 'professional', 'admin'])->default('client');
            $table->string('city')->nullable();
            $table->enum('status', ['active', 'suspended', 'inactive'])->default('active');
            $table->string('stripe_customer_id')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->rememberToken();
            $table->timestamps();
            
            $table->index('firebase_uid');
            $table->index('email');
            $table->index('role');
            $table->index('city');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
