<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('favorites', function (Blueprint $table) {
            $table->id();
            $table->foreignId('client_id')->constrained('users')->cascadeOnDelete();
            $table->foreignId('professional_id')->constrained('professional_profiles')->cascadeOnDelete();
            $table->timestamps();
            
            $table->unique(['client_id', 'professional_id']);
            $table->index('client_id');
            $table->index('professional_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('favorites');
    }
};
