<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('analytics_cache', function (Blueprint $table) {
            $table->id();
            $table->date('date');
            $table->string('metric_key');
            $table->decimal('value', 12, 2)->default(0);
            $table->string('dimension')->nullable(); // e.g., city, service category
            $table->timestamps();
            
            $table->index('date');
            $table->index('metric_key');
            $table->index('dimension');
            $table->unique(['date', 'metric_key', 'dimension']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('analytics_cache');
    }
};
