@extends('layouts.app')

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <div class="bg-white rounded-lg shadow p-8">
        <h1 class="text-3xl font-bold mb-4">{{ $booking->service->name }}</h1>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mb-8">
            <div>
                <h2 class="text-lg font-semibold mb-4">Booking Details</h2>
                <div class="space-y-4">
                    <div>
                        <p class="text-gray-600 text-sm">Professional</p>
                        <p class="font-semibold">{{ $booking->professional->business_name }}</p>
                    </div>
                    <div>
                        <p class="text-gray-600 text-sm">Service</p>
                        <p class="font-semibold">{{ $booking->service->name }}</p>
                    </div>
                    <div>
                        <p class="text-gray-600 text-sm">Date & Time</p>
                        <p class="font-semibold">{{ $booking->scheduled_at->format('M d, Y g:i A') }}</p>
                    </div>
                    <div>
                        <p class="text-gray-600 text-sm">Duration</p>
                        <p class="font-semibold">{{ $booking->duration }} minutes</p>
                    </div>
                    <div>
                        <p class="text-gray-600 text-sm">Location</p>
                        <p class="font-semibold">{{ $booking->city }}</p>
                    </div>
                </div>
            </div>

            <div>
                <h2 class="text-lg font-semibold mb-4">Payment Summary</h2>
                <div class="space-y-4 border-b pb-4 mb-4">
                    <div class="flex justify-between">
                        <span class="text-gray-600">Service Fee</span>
                        <span class="font-semibold">${{ number_format($booking->amount, 2) }}</span>
                    </div>
                </div>
                <div class="flex justify-between text-lg font-bold mb-6">
                    <span>Total</span>
                    <span class="text-green-600">${{ number_format($booking->amount, 2) }}</span>
                </div>

                <!-- Stripe Payment Form -->
                <form id="payment-form" class="space-y-4">
                    @csrf
                    <div id="card-element" class="border rounded px-4 py-3 bg-gray-50"></div>
                    <button type="submit" class="w-full bg-indigo-600 text-white px-6 py-3 rounded-lg hover:bg-indigo-700 font-semibold">
                        Complete Payment
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<script src="https://js.stripe.com/v3/"></script>
<script>
    const stripe = Stripe('{{ config("services.stripe.public") }}');
    const elements = stripe.elements();
    const cardElement = elements.create('card');
    cardElement.mount('#card-element');

    const form = document.getElementById('payment-form');
    form.addEventListener('submit', async (e) => {
        e.preventDefault();
        
        const { paymentIntent, error } = await stripe.confirmCardPayment(
            '{{ $booking->id }}',
            {
                payment_method: {
                    card: cardElement
                }
            }
        );

        if (error) {
            alert(error.message);
        } else if (paymentIntent.status === 'succeeded') {
            document.location.href = '{{ route("booking.confirmation", $booking->id) }}';
        }
    });
</script>
@endsection
