@extends('layouts.app')

@section('content')
<div class="max-w-2xl mx-auto px-4 py-12">
    <h1 class="text-4xl font-bold mb-8">Contact Us</h1>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
        <div class="bg-white rounded-lg shadow p-8">
            <h2 class="text-xl font-bold mb-6">Get in Touch</h2>
            <form class="space-y-4">
                <div>
                    <label class="block text-sm font-medium mb-2">Name</label>
                    <input type="text" class="w-full border rounded-lg px-4 py-2" placeholder="Your name">
                </div>
                <div>
                    <label class="block text-sm font-medium mb-2">Email</label>
                    <input type="email" class="w-full border rounded-lg px-4 py-2" placeholder="Your email">
                </div>
                <div>
                    <label class="block text-sm font-medium mb-2">Message</label>
                    <textarea class="w-full border rounded-lg px-4 py-2 h-32" placeholder="Your message"></textarea>
                </div>
                <button type="submit" class="w-full bg-indigo-600 text-white px-6 py-3 rounded-lg hover:bg-indigo-700 font-semibold">
                    Send Message
                </button>
            </form>
        </div>

        <div class="bg-white rounded-lg shadow p-8">
            <h2 class="text-xl font-bold mb-6">Contact Information</h2>
            <div class="space-y-6">
                <div>
                    <h3 class="font-semibold mb-2">Email</h3>
                    <p class="text-gray-600"><a href="mailto:support@styleseat.local" class="hover:underline">support@styleseat.local</a></p>
                </div>
                <div>
                    <h3 class="font-semibold mb-2">Phone</h3>
                    <p class="text-gray-600">+1 (555) 123-4567</p>
                </div>
                <div>
                    <h3 class="font-semibold mb-2">Address</h3>
                    <p class="text-gray-600">
                        StyleSeat, Inc.<br>
                        Beauty & Wellness Platform<br>
                        New York, NY 10001
                    </p>
                </div>
                <div>
                    <h3 class="font-semibold mb-2">Business Hours</h3>
                    <p class="text-gray-600">
                        Monday - Friday: 9AM - 6PM EST<br>
                        Saturday - Sunday: 10AM - 4PM EST
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
