@extends('installer.layout')

@section('content')
<div class="bg-white rounded-lg shadow-lg p-8 max-w-2xl mx-auto">
    <h2 class="text-2xl font-bold text-gray-900 mb-2">Create Administrator User</h2>
    <p class="text-gray-600 mb-6">Create your first administrator account to manage the application.</p>

    <div class="message-container"></div>

    <form id="adminForm" class="space-y-6">
        <!-- Name -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">Full Name</label>
            <input type="text" name="name" placeholder="John Doe" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent" required>
        </div>

        <!-- Email -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">Email Address</label>
            <input type="email" name="email" placeholder="admin@example.com" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent" required>
            <p class="text-gray-500 text-xs mt-1">This email will be used to log in</p>
        </div>

        <!-- Password -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">Password</label>
            <input type="password" name="password" placeholder="••••••••" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent" required minlength="8">
            <p class="text-gray-500 text-xs mt-1">At least 8 characters</p>
        </div>

        <!-- Confirm Password -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">Confirm Password</label>
            <input type="password" name="password_confirmation" placeholder="••••••••" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent" required minlength="8">
        </div>

        <div class="bg-yellow-50 border-l-4 border-yellow-500 p-4">
            <p class="text-yellow-700 text-sm">
                💡 <strong>Tip:</strong> Make sure to remember this password. You'll need it to log in after installation.
            </p>
        </div>
    </form>

    <div class="flex gap-4 mt-6">
        <a href="{{ route('installer.migration') }}" class="flex-1 bg-gray-600 hover:bg-gray-700 text-white font-bold py-3 px-4 rounded-lg text-center transition">
            ← Back
        </a>
        <button type="button" id="createBtn" class="flex-1 bg-purple-600 hover:bg-purple-700 text-white font-bold py-3 px-4 rounded-lg text-center transition">
            Create Admin User →
        </button>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.getElementById('createBtn').addEventListener('click', async () => {
    const form = document.getElementById('adminForm');
    const formData = new FormData(form);

    // Validate passwords match
    if (formData.get('password') !== formData.get('password_confirmation')) {
        showMessage('Passwords do not match', 'error');
        return;
    }

    const data = {
        name: formData.get('name'),
        email: formData.get('email'),
        password: formData.get('password'),
        password_confirmation: formData.get('password_confirmation'),
    };

    const btn = document.getElementById('createBtn');
    btn.disabled = true;
    btn.textContent = 'Creating...';

    const result = await makeRequest('{{ route("installer.admin.create") }}', 'POST', data);
    
    if (result.success) {
        showMessage(result.message, 'success');
        setTimeout(() => {
            window.location.href = '{{ route("installer.completion") }}';
        }, 1000);
    } else {
        showMessage(result.message, 'error');
        btn.disabled = false;
        btn.textContent = 'Create Admin User →';
    }
});
</script>
@endsection
