@extends('installer.layout')

@section('content')
<div class="bg-white rounded-lg shadow-lg p-8 max-w-2xl mx-auto">
    <div class="text-center mb-8">
        <svg class="w-20 h-20 mx-auto text-green-500 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
        </svg>
        <h2 class="text-3xl font-bold text-gray-900 mb-2">Installation Complete! 🎉</h2>
        <p class="text-gray-600">Your StyleSeat application is ready to use.</p>
    </div>

    <div class="bg-green-50 border-l-4 border-green-500 p-4 mb-8">
        <h3 class="text-lg font-semibold text-green-900 mb-2">✓ Setup Successful</h3>
        <ul class="text-green-700 space-y-1 text-sm">
            <li>✓ System requirements verified</li>
            <li>✓ Database configured and connected</li>
            <li>✓ Database tables created</li>
            <li>✓ Test data seeded (optional)</li>
            <li>✓ Administrator user created</li>
            <li>✓ Application ready for use</li>
        </ul>
    </div>

    <div class="bg-blue-50 border-l-4 border-blue-500 p-4 mb-8">
        <h3 class="text-lg font-semibold text-blue-900 mb-2">Next Steps</h3>
        <ol class="text-blue-700 space-y-2 text-sm">
            <li class="flex items-start">
                <span class="font-bold mr-3">1.</span>
                <span>Click the button below to complete the installation</span>
            </li>
            <li class="flex items-start">
                <span class="font-bold mr-3">2.</span>
                <span>You'll be redirected to the login page</span>
            </li>
            <li class="flex items-start">
                <span class="font-bold mr-3">3.</span>
                <span>Log in with your administrator credentials</span>
            </li>
            <li class="flex items-start">
                <span class="font-bold mr-3">4.</span>
                <span>Explore the application and customize settings</span>
            </li>
        </ol>
    </div>

    <div class="bg-yellow-50 border-l-4 border-yellow-500 p-4 mb-8">
        <h3 class="text-lg font-semibold text-yellow-900 mb-2">Important Notes</h3>
        <ul class="text-yellow-700 space-y-1 text-sm">
            <li>• The installer directory will be locked after completion</li>
            <li>• You can reinstall by deleting the installation lock file</li>
            <li>• Configure Firebase and Stripe in Admin Settings for full functionality</li>
            <li>• Review the README.md file for configuration details</li>
        </ul>
    </div>

    <div class="message-container"></div>

    <div class="flex gap-4">
        <button type="button" id="finalizeBtn" class="flex-1 bg-green-600 hover:bg-green-700 text-white font-bold py-3 px-4 rounded-lg text-center transition">
            ✓ Complete Installation
        </button>
    </div>

    <p class="text-center text-gray-500 text-sm mt-6">
        You will be redirected to the application automatically
    </p>
</div>
@endsection

@section('scripts')
<script>
document.getElementById('finalizeBtn').addEventListener('click', async () => {
    const btn = document.getElementById('finalizeBtn');
    btn.disabled = true;
    btn.textContent = 'Finalizing...';

    const result = await makeRequest('{{ route("installer.finalize") }}', 'POST');
    
    if (result.success) {
        showMessage('Installation finalized successfully!', 'success');
        setTimeout(() => {
            window.location.href = '/';
        }, 2000);
    } else {
        showMessage(result.message, 'error');
        btn.disabled = false;
        btn.textContent = '✓ Complete Installation';
    }
});
</script>
@endsection
