@extends('installer.layout')

@section('content')
<div class="bg-white rounded-lg shadow-lg p-8">
    <h2 class="text-2xl font-bold text-gray-900 mb-2">Application Configuration</h2>
    <p class="text-gray-600 mb-6">Configure basic application settings.</p>

    <div class="message-container"></div>

    <form id="configForm" class="space-y-6">
        <!-- App Name -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">Application Name</label>
            <input type="text" name="app_name" value="{{ $appName }}" placeholder="StyleSeat" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent" required>
            <p class="text-gray-500 text-xs mt-1">This name will appear throughout your application</p>
        </div>

        <!-- App URL -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">Application URL</label>
            <input type="url" name="app_url" value="{{ $appUrl }}" placeholder="http://localhost:8000" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent" required>
            <p class="text-gray-500 text-xs mt-1">The URL where your application will be accessible</p>
        </div>

        <!-- Environment -->
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-2">Environment</label>
            <select name="app_env" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent" required>
                <option value="local" {{ $appEnv === 'local' ? 'selected' : '' }}>Development (Local)</option>
                <option value="staging">Staging</option>
                <option value="production">Production</option>
            </select>
            <p class="text-gray-500 text-xs mt-1">Choose development for testing, production for live sites</p>
        </div>

        <!-- Debug Mode -->
        <div>
            <label class="flex items-center">
                <input type="checkbox" name="app_debug" id="appDebug" class="w-4 h-4 text-purple-600 border-gray-300 rounded focus:ring-purple-500" {{ $appEnv === 'local' ? 'checked' : '' }}>
                <span class="ml-2 text-sm font-medium text-gray-700">Enable Debug Mode</span>
            </label>
            <p class="text-gray-500 text-xs mt-1">Shows detailed error information (disable in production)</p>
        </div>

        <script>
        document.querySelector('select[name="app_env"]').addEventListener('change', (e) => {
            document.getElementById('appDebug').checked = e.target.value === 'local';
        });
        </script>
    </form>

    <div class="flex gap-4 mt-6">
        <a href="{{ route('installer.database') }}" class="flex-1 bg-gray-600 hover:bg-gray-700 text-white font-bold py-3 px-4 rounded-lg text-center transition">
            ← Back
        </a>
        <button type="button" id="saveBtn" class="flex-1 bg-purple-600 hover:bg-purple-700 text-white font-bold py-3 px-4 rounded-lg text-center transition">
            Next: Migrate Database →
        </button>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.getElementById('saveBtn').addEventListener('click', async () => {
    const form = document.getElementById('configForm');
    const formData = new FormData(form);

    const data = {
        app_name: formData.get('app_name'),
        app_url: formData.get('app_url'),
        app_env: formData.get('app_env'),
        app_debug: formData.get('app_debug') ? true : false,
    };

    const btn = document.getElementById('saveBtn');
    btn.disabled = true;
    btn.textContent = 'Saving...';

    const result = await makeRequest('{{ route("installer.configuration.save") }}', 'POST', data);
    
    if (result.success) {
        showMessage(result.message, 'success');
        setTimeout(() => {
            window.location.href = '{{ route("installer.migration") }}';
        }, 1000);
    } else {
        showMessage(result.message, 'error');
        btn.disabled = false;
        btn.textContent = 'Next: Migrate Database →';
    }
});
</script>
@endsection
