@extends('installer.layout')

@section('content')
<div class="bg-white rounded-lg shadow-lg p-8">
    <h2 class="text-2xl font-bold text-gray-900 mb-2">Database Configuration</h2>
    <p class="text-gray-600 mb-6">Configure your database connection details. The installer can also create the database for you if it doesn't exist.</p>

    <div class="message-container"></div>

    <form id="databaseForm" class="space-y-6">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Database Driver -->
            <div class="md:col-span-2">
                <label class="block text-sm font-medium text-gray-700 mb-2">Database Driver</label>
                <select name="driver" id="driver" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent" required>
                    <option value="mysql" {{ $dbDriver === 'mysql' ? 'selected' : '' }}>MySQL / MariaDB</option>
                    <option value="pgsql">PostgreSQL</option>
                    <option value="sqlite">SQLite</option>
                    <option value="sqlsrv">SQL Server</option>
                </select>
            </div>

            <!-- Host -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Host</label>
                <input type="text" name="host" value="{{ $dbHost }}" placeholder="127.0.0.1" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent" required>
                <p class="text-gray-500 text-xs mt-1">Usually localhost or 127.0.0.1</p>
            </div>

            <!-- Port -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Port</label>
                <input type="number" name="port" value="{{ $dbPort }}" placeholder="3306" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent" required>
                <p class="text-gray-500 text-xs mt-1">Default: 3306 for MySQL</p>
            </div>

            <!-- Database Name -->
            <div class="md:col-span-2">
                <label class="block text-sm font-medium text-gray-700 mb-2">Database Name</label>
                <input type="text" name="database" value="{{ $dbDatabase }}" placeholder="styleseat" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent" required>
                <p class="text-gray-500 text-xs mt-1">The name of your database</p>
            </div>

            <!-- Username -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Username</label>
                <input type="text" name="username" value="{{ $dbUsername }}" placeholder="root" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent" required>
            </div>

            <!-- Password -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Password</label>
                <input type="password" name="password" placeholder="Leave blank if no password" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-transparent">
            </div>

            <!-- Create Database -->
            <div class="md:col-span-2">
                <label class="flex items-center">
                    <input type="checkbox" name="create_database" id="createDatabase" class="w-4 h-4 text-purple-600 border-gray-300 rounded focus:ring-purple-500">
                    <span class="ml-2 text-sm font-medium text-gray-700">Create database if it doesn't exist</span>
                </label>
                <p class="text-gray-500 text-xs mt-1">The database user must have CREATE privilege</p>
            </div>
        </div>

        <!-- Test Connection Button -->
        <div class="flex gap-4">
            <button type="button" id="testBtn" class="flex-1 bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg transition">
                Test Connection
            </button>
        </div>
    </form>

    <div class="flex gap-4 mt-6">
        <a href="{{ route('installer.requirements') }}" class="flex-1 bg-gray-600 hover:bg-gray-700 text-white font-bold py-3 px-4 rounded-lg text-center transition">
            ← Back
        </a>
        <button type="button" id="nextBtn" disabled class="flex-1 bg-purple-600 hover:bg-purple-700 text-white font-bold py-3 px-4 rounded-lg text-center transition disabled:bg-gray-400 disabled:cursor-not-allowed">
            Next: Configure App →
        </button>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.getElementById('testBtn').addEventListener('click', async () => {
    const form = document.getElementById('databaseForm');
    const formData = new FormData(form);
    
    const btn = document.getElementById('testBtn');
    btn.disabled = true;
    btn.textContent = 'Testing...';

    const data = {
        driver: formData.get('driver'),
        host: formData.get('host'),
        port: formData.get('port'),
        database: formData.get('database'),
        username: formData.get('username'),
        password: formData.get('password'),
    };

    const result = await makeRequest('{{ route("installer.database.test") }}', 'POST', data);
    
    btn.disabled = false;
    btn.textContent = 'Test Connection';

    if (result.success) {
        showMessage(result.message, 'success');
        document.getElementById('nextBtn').disabled = false;
    } else {
        showMessage(result.message, 'error');
    }
});

document.getElementById('nextBtn').addEventListener('click', async () => {
    const form = document.getElementById('databaseForm');
    const formData = new FormData(form);

    const data = {
        driver: formData.get('driver'),
        host: formData.get('host'),
        port: formData.get('port'),
        database: formData.get('database'),
        username: formData.get('username'),
        password: formData.get('password'),
        create_database: formData.get('create_database') ? true : false,
    };

    const btn = document.getElementById('nextBtn');
    btn.disabled = true;
    btn.textContent = 'Saving...';

    const result = await makeRequest('{{ route("installer.database.save") }}', 'POST', data);
    
    if (result.success) {
        showMessage(result.message, 'success');
        setTimeout(() => {
            window.location.href = '{{ route("installer.configuration") }}';
        }, 1000);
    } else {
        showMessage(result.message, 'error');
        btn.disabled = false;
        btn.textContent = 'Next: Configure App →';
    }
});
</script>
@endsection
