@extends('installer.layout')

@section('content')
<div class="bg-white rounded-lg shadow-lg p-8">
    <h2 class="text-2xl font-bold text-gray-900 mb-6">System Requirements Check</h2>

    <div class="space-y-4 mb-8">
        @foreach($requirements as $key => $requirement)
        <div class="border rounded-lg p-4 {{ $requirement['passed'] ? 'border-green-200 bg-green-50' : 'border-red-200 bg-red-50' }}">
            <div class="flex items-start justify-between">
                <div class="flex-1">
                    <h3 class="font-semibold {{ $requirement['passed'] ? 'text-green-900' : 'text-red-900' }}">
                        {{ $requirement['name'] }}
                    </h3>
                    <div class="mt-2 text-sm {{ $requirement['passed'] ? 'text-green-700' : 'text-red-700' }}">
                        <p><strong>Required:</strong> {{ $requirement['required'] }}</p>
                        <p><strong>Current:</strong> {{ $requirement['current'] }}</p>
                    </div>
                </div>
                <div class="ml-4">
                    @if($requirement['passed'])
                        <svg class="w-8 h-8 text-green-500" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        </svg>
                    @else
                        <svg class="w-8 h-8 text-red-500" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" />
                        </svg>
                    @endif
                </div>
            </div>
        </div>
        @endforeach
    </div>

    @if(!$canProceed)
    <div class="bg-red-100 border-l-4 border-red-500 p-4 mb-8">
        <h3 class="text-lg font-semibold text-red-900 mb-2">⚠️ Installation Blocked</h3>
        <p class="text-red-700 text-sm">
            Your system does not meet all requirements. Please fix the issues above before proceeding.
            You may need to:
        </p>
        <ul class="text-red-700 text-sm mt-2 space-y-1 ml-4">
            <li>• Update PHP to version 8.2 or higher</li>
            <li>• Enable required PHP extensions (check with your hosting provider)</li>
            <li>• Make directories writable (chmod 775 storage/ bootstrap/cache/)</li>
            <li>• Create or fix .env file permissions</li>
        </ul>
    </div>
    @else
    <div class="bg-green-100 border-l-4 border-green-500 p-4 mb-8">
        <p class="text-green-700 font-semibold">✓ All requirements met! You can proceed with installation.</p>
    </div>
    @endif

    <div class="flex gap-4">
        <a href="{{ route('installer.welcome') }}" class="flex-1 bg-gray-600 hover:bg-gray-700 text-white font-bold py-3 px-4 rounded-lg text-center transition">
            ← Back
        </a>
        @if($canProceed)
        <a href="{{ route('installer.database') }}" class="flex-1 bg-purple-600 hover:bg-purple-700 text-white font-bold py-3 px-4 rounded-lg text-center transition">
            Next: Configure Database →
        </a>
        @else
        <button disabled class="flex-1 bg-gray-400 text-white font-bold py-3 px-4 rounded-lg text-center cursor-not-allowed">
            Next: Configure Database →
        </button>
        @endif
    </div>
</div>
@endsection
