@extends('installer.layout')

@section('content')
<div class="bg-white rounded-lg shadow-lg p-8 max-w-2xl mx-auto">
    <div class="text-center mb-8">
        <svg class="w-24 h-24 mx-auto text-purple-600 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
        </svg>
        <h2 class="text-3xl font-bold text-gray-900 mb-2">Welcome to StyleSeat</h2>
        <p class="text-gray-600">Let's get your beauty and wellness marketplace up and running!</p>
    </div>

    <div class="bg-blue-50 border-l-4 border-blue-500 p-4 mb-8">
        <h3 class="text-lg font-semibold text-blue-900 mb-2">Installation Overview</h3>
        <ol class="text-blue-800 space-y-2 text-sm">
            <li class="flex items-start">
                <span class="font-bold mr-3">1.</span>
                <span>Check system requirements and environment configuration</span>
            </li>
            <li class="flex items-start">
                <span class="font-bold mr-3">2.</span>
                <span>Configure database connection and create database if needed</span>
            </li>
            <li class="flex items-start">
                <span class="font-bold mr-3">3.</span>
                <span>Set application configuration (name, URL, environment)</span>
            </li>
            <li class="flex items-start">
                <span class="font-bold mr-3">4.</span>
                <span>Run database migrations to create all tables</span>
            </li>
            <li class="flex items-start">
                <span class="font-bold mr-3">5.</span>
                <span>Optionally seed test data (demo users, bookings, etc.)</span>
            </li>
            <li class="flex items-start">
                <span class="font-bold mr-3">6.</span>
                <span>Create administrator user account</span>
            </li>
            <li class="flex items-start">
                <span class="font-bold mr-3">7.</span>
                <span>Complete installation and access your application</span>
            </li>
        </ol>
    </div>

    <div class="bg-yellow-50 border-l-4 border-yellow-500 p-4 mb-8">
        <h3 class="text-lg font-semibold text-yellow-900 mb-2">⚠️ Before You Begin</h3>
        <ul class="text-yellow-800 space-y-1 text-sm">
            <li>✓ Ensure MySQL/MariaDB is installed and running</li>
            <li>✓ Have your database credentials ready (host, port, username, password)</li>
            <li>✓ PHP 8.2+ is required</li>
            <li>✓ All required PHP extensions must be installed</li>
        </ul>
    </div>

    <div class="flex gap-4">
        <a href="{{ route('installer.requirements') }}" class="flex-1 bg-purple-600 hover:bg-purple-700 text-white font-bold py-3 px-4 rounded-lg text-center transition">
            Get Started →
        </a>
    </div>

    <p class="text-center text-gray-500 text-sm mt-6">
        Already installed? <a href="/" class="text-purple-600 hover:underline">Go to application</a>
    </p>
</div>
@endsection
