@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <div class="mb-8">
        <h1 class="text-4xl font-bold">{{ $professional->business_name }}</h1>
        <div class="flex items-center space-x-4 mt-4">
            <div class="flex items-center">
                <span class="text-yellow-400 text-2xl">⭐</span>
                <span class="ml-2 text-xl font-bold">{{ $professional->rating }}</span>
                <span class="text-gray-500 ml-2">({{ $professional->getReviewCount() }} reviews)</span>
            </div>
            <span class="text-gray-500">📍 {{ $professional->city }}</span>
            <span class="text-gray-500">📅 {{ $upcomingBookings }} upcoming bookings</span>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 mb-8">
        <!-- Image Gallery -->
        <div class="lg:col-span-1">
            <div class="bg-gray-200 rounded-lg aspect-square mb-4 overflow-hidden">
                @if($professional->gallery->count() > 0)
                    <img src="{{ $professional->gallery->first()->image_url }}" alt="Portfolio" class="w-full h-full object-cover">
                @else
                    <div class="w-full h-full flex items-center justify-center text-gray-400">No images</div>
                @endif
            </div>
            
            @if($professional->gallery->count() > 1)
                <div class="grid grid-cols-4 gap-2">
                    @foreach($professional->gallery->take(4) as $image)
                        <img src="{{ $image->image_url }}" alt="Portfolio" class="w-full aspect-square object-cover rounded cursor-pointer">
                    @endforeach
                </div>
            @endif

            @auth
                <button class="w-full mt-4 bg-red-500 text-white px-4 py-2 rounded-lg hover:bg-red-600 toggle-favorite" data-professional="{{ $professional->id }}">
                    <span class="heart-icon">{{ $isFavorite ? '❤️' : '🤍' }}</span>
                    <span class="heart-text">{{ $isFavorite ? 'Remove from Favorites' : 'Add to Favorites' }}</span>
                </button>
            @endauth
        </div>

        <!-- Details -->
        <div class="lg:col-span-2">
            <!-- Services -->
            <div class="mb-8">
                <h2 class="text-2xl font-bold mb-4">Services</h2>
                <div class="space-y-3">
                    @foreach($professional->services as $service)
                        <div class="border rounded-lg p-4 flex justify-between items-start">
                            <div>
                                <h3 class="font-semibold">{{ $service->name }}</h3>
                                <p class="text-gray-600 text-sm">{{ $service->duration }} minutes</p>
                                @if($service->description)
                                    <p class="text-gray-600 text-sm mt-1">{{ $service->description }}</p>
                                @endif
                            </div>
                            <div class="text-right">
                                <p class="text-2xl font-bold text-indigo-600">${{ number_format($service->price, 2) }}</p>
                                @auth
                                    <a href="{{ route('booking.create', $professional->id) }}" class="block mt-2 bg-indigo-600 text-white px-4 py-2 rounded hover:bg-indigo-700 text-sm">Book</a>
                                @else
                                    <a href="{{ route('login') }}" class="block mt-2 bg-indigo-600 text-white px-4 py-2 rounded hover:bg-indigo-700 text-sm">Sign In to Book</a>
                                @endauth
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>

            <!-- About -->
            @if($professional->bio)
                <div class="mb-8">
                    <h2 class="text-2xl font-bold mb-4">About</h2>
                    <p class="text-gray-700 leading-relaxed">{{ $professional->bio }}</p>
                </div>
            @endif

            <!-- Specialties -->
            @if($professional->specialties)
                <div class="mb-8">
                    <h2 class="text-2xl font-bold mb-4">Specialties</h2>
                    <div class="flex flex-wrap gap-2">
                        @foreach($professional->specialties as $specialty)
                            <span class="bg-indigo-100 text-indigo-800 px-4 py-2 rounded-full text-sm font-medium">{{ $specialty }}</span>
                        @endforeach
                    </div>
                </div>
            @endif
        </div>
    </div>

    <!-- Reviews -->
    <div class="bg-white rounded-lg shadow p-8 mb-8">
        <h2 class="text-2xl font-bold mb-6">Reviews</h2>
        <div class="space-y-6">
            @forelse($professional->reviews as $review)
                <div class="border-b pb-6 last:border-b-0">
                    <div class="flex items-center mb-2">
                        <span class="text-yellow-400 text-lg">
                            @for($i = 0; $i < $review->rating; $i++) ⭐ @endfor
                        </span>
                        <span class="ml-2 font-semibold">{{ $review->client->user->name }}</span>
                    </div>
                    <p class="text-gray-700">{{ $review->comment }}</p>
                    <p class="text-gray-500 text-sm mt-2">{{ $review->created_at->diffForHumans() }}</p>
                </div>
            @empty
                <p class="text-gray-500">No reviews yet.</p>
            @endforelse
        </div>
    </div>
</div>

<script>
    document.querySelectorAll('.toggle-favorite').forEach(btn => {
        btn.addEventListener('click', async () => {
            const professionalId = btn.dataset.professional;
            const response = await fetch(`/api/professional/${professionalId}/favorite`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                }
            });
            const data = await response.json();
            const icon = btn.querySelector('.heart-icon');
            const text = btn.querySelector('.heart-text');
            if (data.isFavorite) {
                icon.textContent = '❤️';
                text.textContent = 'Remove from Favorites';
            } else {
                icon.textContent = '🤍';
                text.textContent = 'Add to Favorites';
            }
        });
    });
</script>
@endsection
