<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\SearchController;
use App\Http\Controllers\ProfessionalController;
use App\Http\Controllers\BookingController;
use App\Http\Controllers\InstallerController;
use App\Http\Controllers\Client\DashboardController as ClientDashboardController;
use App\Http\Controllers\Professional\DashboardController as ProfessionalDashboardController;
use App\Http\Controllers\Admin\DashboardController as AdminDashboardController;
use App\Http\Controllers\Admin\UserController as AdminUserController;
use App\Http\Controllers\Admin\BookingController as AdminBookingController;
use App\Http\Controllers\Admin\TransactionController as AdminTransactionController;
use App\Http\Controllers\Admin\SettingController as AdminSettingController;

// Installer routes
Route::prefix('installer')->name('installer.')->group(function () {
    Route::get('/', [InstallerController::class, 'welcome'])->name('welcome');
    Route::get('/requirements', [InstallerController::class, 'requirements'])->name('requirements');
    Route::get('/database', [InstallerController::class, 'database'])->name('database');
    Route::post('/database/test', [InstallerController::class, 'testDatabase'])->name('database.test');
    Route::post('/database/save', [InstallerController::class, 'saveDatabaseConfig'])->name('database.save');
    Route::get('/configuration', [InstallerController::class, 'configuration'])->name('configuration');
    Route::post('/configuration/save', [InstallerController::class, 'saveConfiguration'])->name('configuration.save');
    Route::get('/migration', [InstallerController::class, 'migration'])->name('migration');
    Route::post('/migration/run', [InstallerController::class, 'runMigrations'])->name('migration.run');
    Route::post('/migration/seed', [InstallerController::class, 'runSeeders'])->name('migration.seed');
    Route::get('/admin', [InstallerController::class, 'admin'])->name('admin');
    Route::post('/admin/create', [InstallerController::class, 'createAdmin'])->name('admin.create');
    Route::get('/completion', [InstallerController::class, 'completion'])->name('completion');
    Route::post('/finalize', [InstallerController::class, 'finalize'])->name('finalize');
});

// Public routes
Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/about', [HomeController::class, 'about'])->name('about');
Route::get('/contact', [HomeController::class, 'contact'])->name('contact');

// Search & Discovery
Route::get('/search', [SearchController::class, 'index'])->name('search');

// Professional profile
Route::get('/professional/{id}', [ProfessionalController::class, 'show'])->name('professional.show');
Route::get('/api/professional/{id}/availability', [ProfessionalController::class, 'getAvailability']);

// Authenticated routes
Route::middleware('auth')->group(function () {
    // Professional routes
    Route::post('/api/professional/{id}/favorite', [ProfessionalController::class, 'toggleFavorite']);
    
    // Booking routes
    Route::get('/booking/{professionalId}', [BookingController::class, 'create'])->name('booking.create');
    Route::post('/booking', [BookingController::class, 'store'])->name('booking.store');
    Route::get('/booking/{bookingId}/payment', [BookingController::class, 'payment'])->name('booking.payment');
    Route::post('/booking/{bookingId}/confirm', [BookingController::class, 'confirm'])->name('booking.confirm');
    Route::get('/booking/{bookingId}/confirmation', [BookingController::class, 'confirmation'])->name('booking.confirmation');
    Route::post('/booking/{bookingId}/cancel', [BookingController::class, 'cancel'])->name('booking.cancel');
    Route::get('/booking/{bookingId}/review', [BookingController::class, 'review'])->name('booking.review');
    Route::post('/booking/{bookingId}/review', [BookingController::class, 'submitReview'])->name('booking.review.submit');
    
    // Client dashboard
    Route::prefix('client')->name('client.')->group(function () {
        Route::get('/dashboard', [ClientDashboardController::class, 'index'])->name('dashboard');
        Route::get('/bookings', [ClientDashboardController::class, 'bookings'])->name('bookings');
        Route::get('/favorites', [ClientDashboardController::class, 'favorites'])->name('favorites');
        Route::get('/profile', [ClientDashboardController::class, 'profile'])->name('profile');
        Route::post('/profile', [ClientDashboardController::class, 'updateProfile'])->name('profile.update');
        Route::get('/payment-history', [ClientDashboardController::class, 'paymentHistory'])->name('payment-history');
    });
    
    // Professional routes
    Route::middleware('role:professional')->prefix('professional')->name('professional.')->group(function () {
        Route::get('/dashboard', [ProfessionalDashboardController::class, 'index'])->name('dashboard');
        Route::get('/bookings', [ProfessionalDashboardController::class, 'bookings'])->name('bookings');
        Route::get('/calendar', [ProfessionalDashboardController::class, 'calendar'])->name('calendar');
        Route::get('/services', [ProfessionalDashboardController::class, 'services'])->name('services');
        Route::get('/services/{serviceId}', [ProfessionalDashboardController::class, 'editService'])->name('service.edit');
        Route::post('/services/{serviceId}', [ProfessionalDashboardController::class, 'updateService'])->name('service.update');
        Route::delete('/services/{serviceId}', [ProfessionalDashboardController::class, 'deleteService'])->name('service.delete');
        Route::get('/clients', [ProfessionalDashboardController::class, 'clients'])->name('clients');
        Route::get('/settings', [ProfessionalDashboardController::class, 'settings'])->name('settings');
        Route::post('/settings', [ProfessionalDashboardController::class, 'updateSettings'])->name('settings.update');
    });
});

// Admin routes
Route::middleware(['auth', 'role:admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [AdminDashboardController::class, 'index'])->name('dashboard');
    
    // User management
    Route::prefix('users')->name('users.')->group(function () {
        Route::get('/clients', [AdminUserController::class, 'clients'])->name('clients');
        Route::get('/professionals', [AdminUserController::class, 'professionals'])->name('professionals');
        Route::get('/{userId}', [AdminUserController::class, 'show'])->name('show');
        Route::post('/{userId}/status', [AdminUserController::class, 'updateStatus'])->name('status');
        Route::get('/search', [AdminUserController::class, 'search'])->name('search');
    });
    
    // Booking management
    Route::prefix('bookings')->name('bookings.')->group(function () {
        Route::get('/', [AdminBookingController::class, 'index'])->name('index');
        Route::get('/{bookingId}', [AdminBookingController::class, 'show'])->name('show');
        Route::get('/filter', [AdminBookingController::class, 'filter'])->name('filter');
        Route::get('/export/csv', [AdminBookingController::class, 'exportCsv'])->name('export.csv');
    });
    
    // Transaction management
    Route::prefix('transactions')->name('transactions.')->group(function () {
        Route::get('/', [AdminTransactionController::class, 'index'])->name('index');
        Route::get('/{transactionId}', [AdminTransactionController::class, 'show'])->name('show');
        Route::get('/filter', [AdminTransactionController::class, 'filter'])->name('filter');
        Route::get('/export/csv', [AdminTransactionController::class, 'exportCsv'])->name('export.csv');
    });
    
    // Settings
    Route::prefix('settings')->name('settings.')->group(function () {
        Route::get('/', [AdminSettingController::class, 'index'])->name('index');
        Route::post('/{group}', [AdminSettingController::class, 'updateGroup'])->name('update.group');
        Route::get('/app', [AdminSettingController::class, 'appSettings'])->name('app');
        Route::get('/stripe', [AdminSettingController::class, 'stripeSettings'])->name('stripe');
        Route::get('/firebase', [AdminSettingController::class, 'firebaseSettings'])->name('firebase');
        Route::get('/email', [AdminSettingController::class, 'emailSettings'])->name('email');
        Route::post('/', [AdminSettingController::class, 'updateSettings'])->name('update');
    });
});
