@echo off
REM StyleSeat Local Setup Script
REM This script sets up the StyleSeat application for local development

echo ========================================
echo StyleSeat Local Setup
echo ========================================
echo.

REM Step 1: Check PHP
echo [Step 1] Checking PHP installation...
php --version
if errorlevel 1 (
    echo ERROR: PHP is not installed or not in PATH
    exit /b 1
)
echo OK: PHP found
echo.

REM Step 2: Install Composer Dependencies
echo [Step 2] Installing PHP dependencies...
php C:\php\composer.phar install --ignore-platform-req=ext-fileinfo --ignore-platform-req=ext-sodium --no-interaction
if errorlevel 1 (
    echo ERROR: Composer install failed
    exit /b 1
)
echo OK: PHP dependencies installed
echo.

REM Step 3: Generate App Key
echo [Step 3] Generating app key...
php artisan key:generate
echo OK: App key generated
echo.

REM Step 4: Create database (if needed)
echo [Step 4] Database setup...
echo Please ensure MySQL is running and the database 'styleseat' is created
echo You can create it with: mysql -u root -p -e "CREATE DATABASE IF NOT EXISTS styleseat;"
echo.

REM Step 5: Run migrations
echo [Step 5] Running database migrations...
php artisan migrate --seed
if errorlevel 1 (
    echo WARNING: Migrations may have failed. Check database configuration.
)
echo.

REM Step 6: Install Node dependencies
echo [Step 6] Installing JavaScript dependencies...
call npm install
if errorlevel 1 (
    echo WARNING: NPM install may have had issues
)
echo.

REM Step 7: Build assets
echo [Step 7] Building frontend assets...
call npm run build
if errorlevel 1 (
    echo WARNING: Asset build may have had issues
)
echo.

REM Step 8: Start the development server
echo [Step 8] Starting Laravel development server...
echo The application will be available at http://localhost:8000
echo Press Ctrl+C to stop the server
echo.
php artisan serve

pause
